; The test vectors themselves.
;
; Copyright (C) 2012-2022 Patrik Rak (patrik@raxoft.cz)
;
; This source code is released under the MIT license, see included license.txt.

selftests   equ     0           ; Set to 1 to include detailed self tests.

failcheck   equ     0           ; Run the test only after some prior failure.
incheck     equ     1           ; Fail and skip the test in case of IN mismatch.
nocheck     equ     255         ; No special check needed.

mem         equ     data.mem
meml        equ     mem%256
memh        equ     mem/256
memsp       equ     mem+2

jmp         equ     data.jump
jmpl        equ     jmp%256
jmph        equ     jmp/256

self        equ     test.opcode

            if      postccf
stop        equ     256
tail        equ     0x3f
            else
stop        equ     0
tail        equ     0
            endif

testtable:
            if      selftests
            dw      .crc
            dw      .counter
            dw      .shifter
            endif

            dw      .selftest
            
            dw      .scf
            dw      .ccf
            dw      .scf_nec
            dw      .ccf_nec
            dw      .scf_st
            dw      .ccf_st
            dw      .scfccf
            dw      .ccfscf
            
            dw      .daa
            dw      .cpl
            dw      .neg
            dw      .neg_
            
            dw      .add_a_n
            dw      .adc_a_n
            dw      .sub_a_n
            dw      .sbc_a_n
            dw      .and_n
            dw      .xor_n
            dw      .or_n
            dw      .cp_n

            dw      .alo_a_a
            dw      .alo_a_b_c
            dw      .alo_a_d_e
            dw      .alo_a_h_l
            dw      .alo_a_hl
            dw      .alo_a_x
            dw      .alo_a_y
            dw      .alo_a_xyd
            
            dw      .rlca
            dw      .rrca
            dw      .rla
            dw      .rra
            
            dw      .rld
            dw      .rrd
            
            dw      .rlc_a
            dw      .rrc_a
            dw      .rl_a
            dw      .rr_a
            dw      .sla_a
            dw      .sra_a
            dw      .slia_a
            dw      .srl_a
            
            dw      .rlc_r
            dw      .rrc_r
            dw      .rl_r
            dw      .rr_r
            dw      .sla_r
            dw      .sra_r
            dw      .slia_r
            dw      .srl_r
            
            dw      .sro_xyd
            dw      .sro_xyd_r
            
            dw      .inc_a
            dw      .dec_a
            dw      .inc_r
            dw      .dec_r
            dw      .inc_x
            dw      .dec_x
            dw      .inc_xyd
            dw      .dec_xyd
            
            dw      .inc_rr
            dw      .dec_rr
            dw      .inc_xy
            dw      .dec_xy
            
            dw      .add_hl_rr
            dw      .add_ix_rr
            dw      .add_iy_rr
            dw      .adc_hl_rr
            dw      .sbc_hl_rr

            dw      .bit_n_a
            dw      .bit_n_hl
            dw      .bit_n_r
            dw      .bit_n_xyd
            dw      .bit_n_xyd_

            dw      .set_n_a
            dw      .set_n_hl
            dw      .set_n_r
            dw      .set_n_xyd
            dw      .set_n_xyd_
            
            dw      .res_n_a
            dw      .res_n_hl
            dw      .res_n_r
            dw      .res_n_xyd
            dw      .res_n_xyd_
            
            dw      .ldi
            dw      .ldd
            dw      .ldir
            dw      .lddr
            dw      .ldir_nop
            dw      .lddr_nop
            
            dw      .cpi
            dw      .cpd
            dw      .cpir
            dw      .cpdr
            
            dw      .in_a_n
            dw      .in_r_c
            dw      .in_c
            dw      .ini
            dw      .ind
            dw      .inir
            dw      .indr
            dw      .inir_nop
            dw      .indr_nop

            dw      .out_n_a
            dw      .out_c_r
            dw      .out_c_0
            dw      .outi
            dw      .outd
            dw      .otir
            dw      .otdr

            dw      .jp_nn
            dw      .jp_cc_nn
            dw      .jp_hl
            dw      .jp_xy
            
            dw      .jr_n
            dw      .jr_cc_n
            dw      .djnz_n
            
            dw      .call_nn
            dw      .call_cc_nn
           
            dw      .ret
            dw      .ret_cc
            dw      .retn
            dw      .reti
            dw      .reti_retn
            
            dw      .pushpop_rr
            dw      .poppush_af
            dw      .pushpop_xy
            
            dw      .ex_de_hl
            dw      .ex_af_af
            dw      .exx
            dw      .ex_sp_hl
            dw      .ex_sp_xy
            
            dw      .ld_r_r
            dw      .ld_x_x
            dw      .ld_r_xyd
            dw      .ld_xyd_r
            dw      .ld_r_n
            dw      .ld_x_n
            dw      .ld_xyd_n
            dw      .ld_a_rr
            dw      .ld_rr_a
            dw      .ld_a_mem
            dw      .ld_mem_a
            
            dw      .ld_rr_nn
            dw      .ld_xy_nn
            dw      .ld_hl_mem
            dw      .ld_xy_mem
            dw      .ld_rr_mem
            dw      .ld_mem_hl
            dw      .ld_mem_xy
            dw      .ld_mem_rr
            dw      .ld_sp_hl
            dw      .ld_sp_xy

            dw      .ld_i_a
            dw      .ld_r_a
            dw      .ld_a_i
            dw      .ld_a_r
            
            dw      .ei_di
            dw      .im_n
            
            ; rst
            ; halt
            
            dw      0

            include testmacros.asm

            ; Test vector template.
            ; 
            ; Each test consists of the following:
            ; - Bitmask of which of the modified flags are officially documented.
            ; - Three test vectors - base test vector, counter vector and shifter vector.
            ; - The CRCs for each of the available test variants.
            ; - Test name.
            ; - Type of test pre-check, if any.
            ;
            ; The base test vectors specifies the instruction(s) to execute,
            ; the initial value of the memory operand, and the initial
            ; values of the Z80 registers.
            ;
            ; The counter vector specifies which combinations of bits shall
            ; be toggled in the base test vectors. The test vector is
            ; executed once for each possible combination.
            ;
            ; The shifter vector specifies which bits shall be toggled in
            ; the test vector in sequence. After all the initial counter
            ; combinations were executed, the whole process is repeated, but
            ; now also toggling one of the specified shifter bits at a time.
            ;
            ; The pre-check byte specifies if the test should be skipped and under what condition.
            ; Note that it is seldom needed so most often I abuse the flags byte of the following test instead.

            if 0
            flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x00,0x00,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xaf0f0011,all,0xac0f0022,docflags,0xdf0f0033,doc,0xdc0f0044,ccf,0x0,mptr,0x0
            name    " "
            endif

            ; Various selftests.

            if      selftests

.crc        flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x00,0x00,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x00ffffff,all,0x2e26825b,docflags,0x354a5705,doc,0x4a0a6669,ccf,0xb062bcdf,mptr,0x4996b8b2
            name    "CRC TEST"

.counter    flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x00,0x00,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x01,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x8000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x00000000,all,0x65283e9d,docflags,0x3b3096d9,doc,0x70844659,ccf,0xa424358c,mptr,0x1f36a1d1
            name    "COUNTER TEST"

.shifter    flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x00,0x00,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x41,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x8000
            crcs    allflags,0x00000000,all,0xd690f8ac,docflags,0x3b3096d9,doc,0xc33c8068,ccf,0xddc5094f,mptr,0x1f36a1d1
            name    "SHIFTER TEST"

            endif

.selftest   flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x00,0x00,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x20,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x08,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xf3b489a6,all,0x1052d099,docflags,0x3b3096d9,doc,0x48e530ef,ccf,0x97bb028f,mptr,0x1f36a1d1
            name    "SELF TEST"

            ; Flag manipulation.

.scf        flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x37,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x28,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xd7,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x3ec05634,all,0xd841bd8a,docflags,0xafbf608b,doc,0x2efb018b,ccf,0xe0d3c7bf,mptr,0x4fc0a073
            name    "SCF"

.ccf        flags   s,1,z,1,f5,0,hc,0,f3,0,pv,1,n,1,c,1
            vec     0x3f,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x28,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xd7,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x5b2237ae,all,0x3fbb71dc,docflags,0x27b2462c,doc,0x96bd3c82,ccf,0x8531a625,mptr,0xc7cd86d4
            name    "CCF"

.scf_nec    flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x37,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x28,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xd7,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x958e3e1e,all,0x45fc79b5,docflags,0xafbf608b,doc,0x2efb018b,ccf,0xe0d3c7bf,mptr,0x4fc0a073
            name    "SCF (NEC)"
            db      failcheck

.ccf_nec    flags   s,1,z,1,f5,0,hc,0,f3,0,pv,1,n,1,c,1
            vec     0x3f,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x28,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xd7,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xf06c5f84,all,0xa206b5e3,docflags,0x27b2462c,doc,0x96bd3c82,ccf,0x8531a625,mptr,0xc7cd86d4
            name    "CCF (NEC)"
            db      failcheck

.scf_st     flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x37,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x28,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xd7,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xc62af5ee,all,0x58e950e4,docflags,0xafbf608b,doc,0x2efb018b,ccf,0xe0d3c7bf,mptr,0x4fc0a073
            name    "SCF (ST)"
            db      failcheck

.ccf_st     flags   s,1,z,1,f5,0,hc,0,f3,0,pv,1,n,1,c,1
            vec     0x3f,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x28,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xd7,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xa3c89474,all,0xbf139cb2,docflags,0x27b2462c,doc,0x96bd3c82,ccf,0x8531a625,mptr,0xc7cd86d4
            name    "CCF (ST)"
            db      failcheck

.scfccf     flags   s,1,z,1,f5,0,hc,0,f3,0,pv,1,n,1,c,1
            vec     0x37,0x3f,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x28,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xd7,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xe0d3c7bf,all,0x9086496c,docflags,0x6f887d41,doc,0x3f044693,ccf,0x958e3e1e,mptr,0x8ff7bdb9
            name    "SCF+CCF"

.ccfscf     flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x3f,0x37,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x28,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xd7,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x958e3e1e,all,0x45fc79b5,docflags,0xafbf608b,doc,0x2efb018b,ccf,0xe0d3c7bf,mptr,0x4fc0a073
            name    "CCF+SCF"

            ; 8 bit arithmetics.

.daa        flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x27,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x13,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xec,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x4fa2a2d3,all,0xe994c6c4,docflags,0x39bd9b50,doc,0xce050987,ccf,0xf664ae86,mptr,0xb43e3905
            name    "DAA"

.cpl        flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x2f,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x23dcd704,all,0xe39927d0,docflags,0x9c2c0c93,doc,0xe028b087,ccf,0x169b61fe,mptr,0xbd959484
            name    "CPL"

.neg        flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xed,0x44,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xed3cb45e,all,0x953a7650,docflags,0xe5ea9a83,doc,0xe6ed5f0d,ccf,0xb88dd2d9,mptr,0x44007b37
            name    "NEG"

.neg_       flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xed,0x44,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x38,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xb5d3962c,all,0xf5ee4f9e,docflags,0x1666fbfb,doc,0x6b734a21,ccf,0x7282acda,mptr,0x54c2af54
            name    "NEG'"

.add_a_n    flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xc6,0x00,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0xff,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xb68bee38,all,0xe5166f9d,docflags,0x1ec28381,doc,0xb3ac13f8,ccf,0x458111c4,mptr,0x160b129e
            name    "ADD A,N"

.adc_a_n    flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xce,0x00,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0xff,0x00,0x00,mem,0x0000,a,0x00,f,0xfe,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x08d8adb1,all,0x08bbc92b,docflags,0x916c5e39,doc,0x0d4254b3,ccf,0x2b5b8e14,mptr,0x32f9b8f9
            name    "ADC A,N"

.sub_a_n    flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xd6,0x00,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0xff,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x42656897,all,0x7a32a565,docflags,0xbd411ef5,doc,0x34d93157,ccf,0x68d32973,mptr,0xfd687592
            name    "SUB A,N"

.sbc_a_n    flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xde,0x00,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0xff,0x00,0x00,mem,0x0000,a,0x00,f,0xfe,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xa09fb8f6,all,0x15158a3a,docflags,0xf3a8f826,doc,0xc9e2149b,ccf,0xf74ae063,mptr,0xecba4131
            name    "SBC A,N"

.and_n      flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xe6,0x00,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0xff,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x1330f710,all,0x344db49a,docflags,0x8e181222,doc,0x48c51db7,ccf,0x4d1c8c24,mptr,0xd5aefd16
            name    "AND N"

.xor_n      flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xee,0x00,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0xff,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xa39216ec,all,0x0e8a64f8,docflags,0x2f5e8c7c,doc,0x4a8b89b9,ccf,0xf37b322f,mptr,0xd5aefd16
            name    "XOR N"

.or_n       flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xf6,0x00,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0xff,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x927c68c0,all,0x984e7d2f,docflags,0x83981762,doc,0xa0c73943,ccf,0xc2954c03,mptr,0xd5aefd16
            name    "OR N"

.cp_n       flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xfe,0x00,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0xff,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xb727231e,all,0xd714639b,docflags,0xbd411ef5,doc,0xe811d64d,ccf,0x115df86a,mptr,0xfd687592
            name    "CP N"

.alo_a_a    flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x87,stop,0x00,0x00,mem,0x1234,a,0x00,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x38,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x7bf17601,all,0x819740db,docflags,0x2a38d86c,doc,0xc8056bb1,ccf,0x5ba4549a,mptr,0x8288f8b5
            name    "ALO A,A"

.alo_a_b_c  flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x80,stop,0x00,0x00,mem,0x1234,a,0x00,f,0xff,bc,0x0000,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x39,0x00,0x00,0x00,mem,0x0000,a,0xc8,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x37,f,0xff,bc,0xffff,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xaf8b1bce,all,0x3b2d5d84,docflags,0xc18f696f,doc,0xe24caea3,ccf,0x9499283b,mptr,0x88db2720
            name    "ALO A,[B,C]"

.alo_a_d_e  flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x82,stop,0x00,0x00,mem,0x1234,a,0x00,f,0xff,bc,0xbbcc,de,0x0000,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x39,0x00,0x00,0x00,mem,0x0000,a,0xc8,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x37,f,0xff,bc,0x0000,de,0xffff,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xaf8b1bce,all,0x48bec1d5,docflags,0xc18f696f,doc,0x91df32f2,ccf,0x9499283b,mptr,0x88db2720
            name    "ALO A,[D,E]"

.alo_a_h_l  flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x84,stop,0x00,0x00,mem,0x1234,a,0x00,f,0xff,bc,0xbbcc,de,0xddee,hl,0x0000,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x39,0x00,0x00,0x00,mem,0x0000,a,0xc8,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x37,f,0xff,bc,0x0000,de,0x0000,hl,0xffff,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xaf8b1bce,all,0x317ada1e,docflags,0xc18f696f,doc,0xe81b2939,ccf,0x9499283b,mptr,0x88db2720
            name    "ALO A,[H,L]"

.alo_a_hl   flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x86,stop,0x00,0x00,mem,0x1200,a,0x00,f,0xff,bc,0xbbcc,de,0xddee,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x38,0x00,0x00,0x00,mem,0x0000,a,0xc8,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x00ff,a,0x37,f,0xff,bc,0x0000,de,0x0000,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xc0f1f3d4,all,0xd6da14b8,docflags,0x4aa02f3b,doc,0x903b071b,ccf,0xc9f87d81,mptr,0x52dee881
            name    "ALO A,(HL)"

.alo_a_x    flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xdd,0x84,stop,0x00,mem,0x1234,a,0x00,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0x0000,iy,0xfd77,sp,0xc000
            vec     0x00,0x39,0x00,0x00,mem,0x0000,a,0xc8,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x37,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0xffff,iy,0x0000,sp,0x0000
            crcs    allflags,0xaf8b1bce,all,0x0fe83ffa,docflags,0xc18f696f,doc,0xd689ccdd,ccf,0x9499283b,mptr,0x88db2720
            name    "ALO A,[HX,LX]"

.alo_a_y    flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xfd,0x84,stop,0x00,mem,0x1234,a,0x00,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0x0000,sp,0xc000
            vec     0x00,0x39,0x00,0x00,mem,0x0000,a,0xc8,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x37,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0xffff,sp,0x0000
            crcs    allflags,0xaf8b1bce,all,0x57fe309a,docflags,0xc18f696f,doc,0x8e9fc3bd,ccf,0x9499283b,mptr,0x88db2720
            name    "ALO A,[HY,LY]"

.alo_a_xyd  flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xdd,0x86,0x00,stop,mem,0x1200,a,0x00,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,mem   ,iy,mem   ,sp,0xc000
            vec     0x20,0x38,0x00,0x00,mem,0x0000,a,0xc8,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x01,0x00,mem,0x00ff,a,0x37,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0001,iy,0x0001,sp,0x0000
            crcs    allflags,0x0688d4d0,all,0x0e199fc6,docflags,0x1cff9540,doc,0xacb41617,ccf,0x12a5f62d,mptr,0x8ea78576
            name    "ALO A,(XY)"
            
            ; Shift/Rotation operations.

.rlca       flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x07,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xfe,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xf572e9a6,all,0x2cf14e06,docflags,0x83400114,doc,0x9f1dfe40,ccf,0xd5a70c6a,mptr,0x46c57ece
            name    "RLCA"

.rrca       flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x0f,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xfe,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x02507a39,all,0x022ae290,docflags,0xda065d56,doc,0x01ffafbf,ccf,0xb6b74812,mptr,0x1f83228c
            name    "RRCA"

.rla        flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x17,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xfe,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xf572e9a6,all,0xae39cb75,docflags,0x83400114,doc,0x1dd57b33,ccf,0xd5a70c6a,mptr,0x46c57ece
            name    "RLA"

.rra        flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x1f,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xfe,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x02507a39,all,0x9c6094b6,docflags,0xda065d56,doc,0x9fb5d999,ccf,0xb6b74812,mptr,0x1f83228c
            name    "RRA"

.rld        flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xed,0x6f,stop,0x00,mem,0x1200,a,0x00,f,0xff,bc,0xbbcc,de,0xddee,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0088,a,0x88,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0077,a,0x77,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x31033721,all,0xbfa13284,docflags,0x1289827e,doc,0x9e08d2ce,ccf,0xffa1b2a6,mptr,0x670a95ea
            name    "RLD"

.rrd        flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xed,0x67,stop,0x00,mem,0x1200,a,0x00,f,0xff,bc,0xbbcc,de,0xddee,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0088,a,0x88,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0077,a,0x77,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x144cbc1e,all,0x7db4c060,docflags,0x25caf56c,doc,0x6029a6d6,ccf,0xdaee3999,mptr,0x670a95ea
            name    "RRD"

.rlc_a      flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xcb,0x07,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xfe,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xfd4e5ef3,all,0x283e77e2,docflags,0x8b7cb641,doc,0x9bd2c7a4,ccf,0xdd9bbb3f,mptr,0x46c57ece
            name    "RLC A"

.rrc_a      flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xcb,0x0f,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xfe,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xd42a65e9,all,0x8ec5c37a,docflags,0x0c7c4286,doc,0x8d108e55,ccf,0x60cd57c2,mptr,0x1f83228c
            name    "RRC A"

.rl_a       flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xcb,0x17,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xfe,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x9fcd23ea,all,0xf4284a2f,docflags,0xe9ffcb58,doc,0x47c4fa69,ccf,0xbf18c626,mptr,0x46c57ece
            name    "RL A"

.rr_a       flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xcb,0x1f,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xfe,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x2c01ccfe,all,0x8ff2a587,docflags,0xf457eb91,doc,0x8c27e8a8,ccf,0x98e6fed5,mptr,0x1f83228c
            name    "RR A"

.sla_a      flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xcb,0x27,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xfe,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x14e83f4b,all,0x23575776,docflags,0x62dad7f9,doc,0x90bbe730,ccf,0x343dda87,mptr,0x46c57ece
            name    "SLA A"

.sra_a      flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xcb,0x2f,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xfe,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x2d1ddbfe,all,0x43fd2a03,docflags,0xf54bfc91,doc,0x4028672c,ccf,0x99fae9d5,mptr,0x1f83228c
            name    "SRA A"

.slia_a     flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xcb,0x37,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xfe,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x3e979588,all,0x310e725b,docflags,0x48a57d3a,doc,0x82e2c21d,ccf,0x1e427044,mptr,0x46c57ece
            name    "SLIA A"

.srl_a      flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xcb,0x3f,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xfe,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xdf0809ad,all,0x0dd8dbb3,docflags,0x075e2ec2,doc,0x0e0d969c,ccf,0x6bef3b86,mptr,0x1f83228c
            name    "SRL A"

.rlc_r      flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xcb,0x00,stop,0x00,mem,0x1234,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x07,0x00,0x00,mem,0x0000,a,0x00,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x00ff,a,0xff,f,0xfe,bc,0xffff,de,0xffff,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xa9cf462b,all,0xd0dbb5c9,docflags,0xd846f0af,doc,0x1d40c543,ccf,0x0de3b8d0,mptr,0x583613cd
            name    "RLC [R,(HL)]"

.rrc_r      flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xcb,0x08,stop,0x00,mem,0x1234,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x07,0x00,0x00,mem,0x0000,a,0x00,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x00ff,a,0xff,f,0xfe,bc,0xffff,de,0xffff,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x46951078,all,0x580c3699,docflags,0xa89fed01,doc,0x6e47194f,ccf,0xb3205743,mptr,0x0ef99a43
            name    "RRC [R,(HL)]"

.rl_r       flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xcb,0x10,stop,0x00,mem,0x1234,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x07,0x00,0x00,mem,0x0000,a,0x00,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x00ff,a,0xff,f,0xfe,bc,0xffff,de,0xffff,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x39619ccf,all,0x6ce63685,docflags,0x48e82a4b,doc,0xa17d460f,ccf,0x9d4d6234,mptr,0x583613cd
            name    "RL [R,(HL)]"

.rr_r       flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xcb,0x18,stop,0x00,mem,0x1234,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x07,0x00,0x00,mem,0x0000,a,0x00,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x00ff,a,0xff,f,0xfe,bc,0xffff,de,0xffff,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x92fb276b,all,0xaaef8e65,docflags,0x7cf1da12,doc,0x9ca4a1b3,ccf,0x674e6050,mptr,0x0ef99a43
            name    "RR [R,(HL)]"

.sla_r      flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xcb,0x20,stop,0x00,mem,0x1234,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x07,0x00,0x00,mem,0x0000,a,0x00,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x00ff,a,0xff,f,0xfe,bc,0xffff,de,0xffff,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xf40a2fa5,all,0x964172f2,docflags,0x85839921,doc,0x5bda0278,ccf,0x5026d15e,mptr,0x583613cd
            name    "SLA [R,(HL)]"

.sra_r      flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xcb,0x28,stop,0x00,mem,0x1234,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x07,0x00,0x00,mem,0x0000,a,0x00,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x00ff,a,0xff,f,0xfe,bc,0xffff,de,0xffff,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x8f46e5af,all,0x1fbb780d,docflags,0x614c18d6,doc,0x29f057db,ccf,0x7af3a294,mptr,0x0ef99a43
            name    "SRA [R,(HL)]"

.slia_r     flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xcb,0x30,stop,0x00,mem,0x1234,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x07,0x00,0x00,mem,0x0000,a,0x00,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x00ff,a,0xff,f,0xfe,bc,0xffff,de,0xffff,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x1a61a672,all,0xd709a853,docflags,0x6be810f6,doc,0x1a92d8d9,ccf,0xbe4d5889,mptr,0x583613cd
            name    "SLIA [R,(HL)]"

.srl_r      flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xcb,0x38,stop,0x00,mem,0x1234,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x07,0x00,0x00,mem,0x0000,a,0x00,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x00ff,a,0xff,f,0xfe,bc,0xffff,de,0xffff,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xe3e1480c,all,0xa1ea5b8c,docflags,0x0debb575,doc,0x97a1745a,ccf,0x16540f37,mptr,0x0ef99a43
            name    "SRL [R,(HL)]"

.sro_xyd    flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xdd,0xcb,0x00,0x06,mem,0x1200,a,0xa0,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,mem   ,iy,mem   ,sp,0xc000
            vec     0x20,0x00,0x00,0x38,mem,0x0000,a,0x00,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x01,0x00,mem,0x00ff,a,0x00,f,0xfe,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0001,iy,0x0001,sp,0x0000
            crcs    allflags,0xc76b6fb8,all,0x1cf5bf25,docflags,0x6ed22cb1,doc,0x4ce1c915,ccf,0x634cfd9b,mptr,0xda289a0a
            name    "SRO (XY)"

.sro_xyd_r  flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xdd,0xcb,0x00,0x00,mem,0x1200,a,0xa0,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,mem   ,iy,mem   ,sp,0xc000
            vec     0x20,0x00,0x00,0x3f,mem,0x0000,a,0x00,f,0x01,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x01,0x00,mem,0x00ff,a,0x00,f,0xfe,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0001,iy,0x0001,sp,0x0000
            crcs    allflags,0xd88fde47,all,0x2e23102b,docflags,0x0af8b1a8,doc,0x31dc0d48,ccf,0xa7ae2064,mptr,0xe9fc598c
            name    "SRO (XY),R"

            ; 8 bit inc/dec.

.inc_a      flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x3c,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x41,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xbe,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x87cacbb1,all,0xa55c5156,docflags,0x424ec003,doc,0xef741e2c,ccf,0x79baf440,mptr,0x07fa9b1e
            name    "INC A"

.dec_a      flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x3d,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x41,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xbe,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x63cee668,all,0x36167475,docflags,0xc18a1817,doc,0x6e625809,ccf,0x83519741,mptr,0x07fa9b1e
            name    "DEC A"

.inc_r      flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x04,stop,0x00,0x00,mem,0x0000,a,0xff,f,0xff,bc,0xffff,de,0xffff,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x38,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x41,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x00ff,a,0xff,f,0xbe,bc,0xffff,de,0xffff,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x6d329bb5,all,0xad4583fc,docflags,0xa8353115,doc,0x577d9442,ccf,0xa3e04aee,mptr,0xd2af014c
            name    "INC [R,(HL)]"

.dec_r      flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0x05,stop,0x00,0x00,mem,0xffff,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x38,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x41,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x00ff,a,0xff,f,0xbe,bc,0xffff,de,0xffff,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xe2207af8,all,0xddb3ebf9,docflags,0xea0faeaa,doc,0xfc5aceff,ccf,0x516dcee2,mptr,0xd2af014c
            name    "DEC [R,(HL)]"

.inc_x      flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xdd,0x24,stop,0x00,mem,0x1234,a,0xa0,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xffff,iy,0xffff,sp,0xc000
            vec     0x20,0x08,0x00,0x00,mem,0x0000,a,0x00,f,0x41,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xbe,bc,0x0000,de,0x0000,hl,0x0000,ix,0xffff,iy,0xffff,sp,0x0000
            crcs    allflags,0x72eec05f,all,0xe5a34ced,docflags,0x48355f66,doc,0x0b3690d0,ccf,0xb575fded,mptr,0x061a489c
            name    "INC X"

.dec_x      flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xdd,0x25,stop,0x00,mem,0x1234,a,0xa0,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0x0000,iy,0x0000,sp,0xc000
            vec     0x20,0x08,0x00,0x00,mem,0x0000,a,0x00,f,0x41,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xbe,bc,0x0000,de,0x0000,hl,0x0000,ix,0xffff,iy,0xffff,sp,0x0000
            crcs    allflags,0x307ea05a,all,0x331c7bf9,docflags,0x4f85fe9a,doc,0x79ca0f3e,ccf,0xc272dc96,mptr,0x061a489c
            name    "DEC X"

.inc_xyd    flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xdd,0x34,0x00,stop,mem,0xffff,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,mem   ,iy,mem   ,sp,0xc000
            vec     0x20,0x00,0x00,0x00,mem,0x0001,a,0x00,f,0x41,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x01,0x00,mem,0x00fe,a,0x00,f,0xbe,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0001,iy,0x0001,sp,0x0000
            crcs    allflags,0xdca01a72,all,0x04323153,docflags,0xfd517beb,doc,0x5e36d887,ccf,0xaf1b424a,mptr,0xbae92d6d
            name    "INC (XY)"

.dec_xyd    flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xdd,0x35,0x00,stop,mem,0x0000,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,mem   ,iy,mem   ,sp,0xc000
            vec     0x20,0x00,0x00,0x00,mem,0x0001,a,0x00,f,0x41,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x01,0x00,mem,0x00fe,a,0x00,f,0xbe,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0001,iy,0x0001,sp,0x0000
            crcs    allflags,0xf0c6ba74,all,0xe317913c,docflags,0x95a51d52,doc,0xc707eef8,ccf,0xaffdbb9c,mptr,0xbae92d6d
            name    "DEC (XY)"
            
            ; 16 bit inc/dec.
            
.inc_rr     flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0x03,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xffff,de,0xffff,hl,0xffff,ix,0xdd88,iy,0xfd77,sp,0xffff
            vec     0x30,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0001,de,0x0001,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0001
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0xfffe,de,0xfffe,hl,0xfffe,ix,0x0000,iy,0x0000,sp,0xfffe
            crcs    allflags,0x12137ffe,all,0x8cd11626,docflags,0x12137ffe,doc,0x8cd11626,ccf,0x0cedc91d,mptr,0x48cdbd6b
            name    "INC RR"

.dec_rr     flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0x0b,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0xdd88,iy,0xfd77,sp,0x0000
            vec     0x30,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0001,de,0x0001,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0001
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0xfffe,de,0xfffe,hl,0xfffe,ix,0x0000,iy,0x0000,sp,0xfffe
            crcs    allflags,0x12137ffe,all,0x343b2da0,docflags,0x12137ffe,doc,0x343b2da0,ccf,0x0cedc91d,mptr,0x48cdbd6b
            name    "DEC RR"

.inc_xy     flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xdd,0x23,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xffff,iy,0xffff,sp,0xc000
            vec     0x20,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0001,iy,0x0001,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0xfffe,iy,0xfffe,sp,0x0000
            crcs    allflags,0x9adb43df,all,0xe132d93b,docflags,0x9adb43df,doc,0xe132d93b,ccf,0xc6e8494f,mptr,0xe5d6883e
            name    "INC XY"

.dec_xy     flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xdd,0x2b,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0x0000,iy,0x0000,sp,0xc000
            vec     0x20,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0001,iy,0x0001,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0xfffe,iy,0xfffe,sp,0x0000
            crcs    allflags,0x9adb43df,all,0xd3d07c72,docflags,0x9adb43df,doc,0xd3d07c72,ccf,0xc6e8494f,mptr,0xe5d6883e
            name    "DEC XY"

            ; 16 bit arithmetics.

.add_hl_rr  flags   s,1,z,1,f5,0,hc,0,f3,0,pv,1,n,1,c,1
            vec     0x09,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0xdd88,iy,0xfd77,sp,0x0000
            vec     0x30,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0xc800,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0xffff,de,0xffff,hl,0x37ff,ix,0x0000,iy,0x0000,sp,0xffff
            crcs    allflags,0x38891c0b,all,0xbfd3ba45,docflags,0xc2a83dbb,doc,0x5d49a198,ccf,0x834a2beb,mptr,0xd81b6329
            name    "ADD HL,RR"

.add_ix_rr  flags   s,1,z,1,f5,0,hc,0,f3,0,pv,1,n,1,c,1
            vec     0xdd,0x09,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0x0000,de,0x0000,hl,0x4411,ix,0x0000,iy,0xfd77,sp,0x0000
            vec     0x00,0x30,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0xc800,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0xffff,de,0xffff,hl,0x0000,ix,0x37ff,iy,0x0000,sp,0xffff
            crcs    allflags,0x38891c0b,all,0x4c9bba44,docflags,0xc2a83dbb,doc,0xae01a199,ccf,0x834a2beb,mptr,0xd81b6329
            name    "ADD IX,RR"

.add_iy_rr  flags   s,1,z,1,f5,0,hc,0,f3,0,pv,1,n,1,c,1
            vec     0xfd,0x09,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0x0000,de,0x0000,hl,0x4411,ix,0xdd88,iy,0x0000,sp,0x0000
            vec     0x00,0x30,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0xc800,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0xffff,de,0xffff,hl,0x0000,ix,0x0000,iy,0x37ff,sp,0xffff
            crcs    allflags,0x38891c0b,all,0x5b74c0fe,docflags,0xc2a83dbb,doc,0xb9eedb23,ccf,0x834a2beb,mptr,0xd81b6329
            name    "ADD IY,RR"

.adc_hl_rr  flags   s,1,z,1,f5,0,hc,0,f3,0,pv,1,n,1,c,1
            vec     0xed,0x4a,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0xdd88,iy,0xfd77,sp,0x0000
            vec     0x00,0x30,0x00,0x00,mem,0x0000,a,0x00,f,0x01,bc,0x0000,de,0x0000,hl,0xc800,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xfe,bc,0xffff,de,0xffff,hl,0x37ff,ix,0x0000,iy,0x0000,sp,0xffff
            crcs    allflags,0x422b5c67,all,0x6c7246df,docflags,0x32f5ed56,doc,0x3fdf376d,ccf,0x490ec3d7,mptr,0x00c7e8a8
            name    "ADC HL,RR"

.sbc_hl_rr  flags   s,1,z,1,f5,0,hc,0,f3,0,pv,1,n,1,c,1
            vec     0xed,0x42,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0xdd88,iy,0xfd77,sp,0x0000
            vec     0x00,0x30,0x00,0x00,mem,0x0000,a,0x00,f,0x01,bc,0x0000,de,0x0000,hl,0xc800,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xfe,bc,0xffff,de,0xffff,hl,0x37ff,ix,0x0000,iy,0x0000,sp,0xffff
            crcs    allflags,0xbf3c66bf,all,0x8c5ff28a,docflags,0x053b7ece,doc,0xf63a616d,ccf,0x6ab97a85,mptr,0x67ac8297
            name    "SBC HL,RR"

            ; Bit instructions.

.bit_n_a    flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xcb,0x47,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x38,0x00,0x00,mem,0x0000,a,0x28,f,0x28,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xd7,f,0xd7,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x94eb9955,all,0x3a1914e7,docflags,0x129a36d9,doc,0x254f5b14,ccf,0x2023d1a2,mptr,0xbe47190a
            name    "BIT N,A"

.bit_n_hl   flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xcb,0x46,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x38,0x00,0x00,mem,0x0028,a,0x00,f,0x28,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x00d7,a,0x00,f,0xd7,bc,0x0000,de,0x0000,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xf5d39111,all,0x7f6e6fae,docflags,0x8dcbbff3,doc,0x1fe2af42,ccf,0x77b22658,mptr,0xf3795427
            name    "BIT N,(HL)"

.bit_n_r    flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xcb,0x40,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x3f,0x00,0x00,mem,0x0000,a,0x00,f,0x28,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xd7,bc,0xffff,de,0xffff,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x80f58eca,all,0xb0777901,docflags,0xff835842,doc,0xb7c832b6,ccf,0x736a3cba,mptr,0x60f9121c
            name    "BIT N,[R,(HL)]"

.bit_n_xyd  flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xdd,0xcb,0x00,0x46,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,mem   ,iy,mem   ,sp,0xc000
            vec     0x20,0x00,0x00,0x38,mem,0x0000,a,0x00,f,0x28,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x01,0x00,mem,0x00ff,a,0x00,f,0xd7,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0001,iy,0x0001,sp,0x0000
            crcs    allflags,0x69d8b807,all,0xac375d19,docflags,0x6e0fa1c8,doc,0xd97a7bb8,ccf,0xa16f2455,mptr,0x1085734f
            name    "BIT N,(XY)"

.bit_n_xyd_ flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xdd,0xcb,0x00,0x40,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,mem   ,iy,mem   ,sp,0xc000
            vec     0x20,0x00,0x00,0x3f,mem,0x0000,a,0x00,f,0x28,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x01,0x00,mem,0x00ff,a,0x00,f,0xd7,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0001,iy,0x0001,sp,0x0000
            crcs    allflags,0xb99e5a2e,all,0x8e78e922,docflags,0x6870b827,doc,0x62003a45,ccf,0x32675fd1,mptr,0xef605a9e
            name    "BIT N,(XY),-"

.set_n_a    flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xcb,0xc7,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x38,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xdc6cce34,all,0x0e29860a,docflags,0xdc6cce34,doc,0x0e29860a,ccf,0x56779cfd,mptr,0xf0154dc0
            name    "SET N,A"

.set_n_hl   flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xcb,0xc6,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x38,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x00ff,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xeaf0e45d,all,0x514cc2f6,docflags,0xeaf0e45d,doc,0x514cc2f6,ccf,0xa20c0caf,mptr,0x5d434474
            name    "SET N,(HL)"

.set_n_r    flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xcb,0xc0,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x3f,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0xffff,de,0xffff,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x2bb9d994,all,0xbc87a9e1,docflags,0x2bb9d994,doc,0xbc87a9e1,ccf,0x112577dd,mptr,0x6f46591e
            name    "SET N,[R,(HL)]"

.set_n_xyd  flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xdd,0xcb,0x00,0xc6,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,mem   ,iy,mem   ,sp,0xc000
            vec     0x20,0x00,0x00,0x38,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x01,0x00,mem,0x00ff,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0001,iy,0x0001,sp,0x0000
            crcs    allflags,0x2387ec0d,all,0xfc48dc5a,docflags,0x2387ec0d,doc,0xfc48dc5a,ccf,0xc90fadad,mptr,0xf6d0118d
            name    "SET N,(XY)"

.set_n_xyd_ flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xdd,0xcb,0x00,0xc0,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,mem   ,iy,mem   ,sp,0xc000
            vec     0x20,0x00,0x00,0x3f,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x01,0x00,mem,0x00ff,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0001,iy,0x0001,sp,0x0000
            crcs    allflags,0xdf6769a7,all,0x02392678,docflags,0xdf6769a7,doc,0x02392678,ccf,0x246fb380,mptr,0x4ba4554c
            name    "SET N,(XY),R"

.res_n_a    flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xcb,0x87,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x38,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xdc6cce34,all,0x002d3c76,docflags,0xdc6cce34,doc,0x002d3c76,ccf,0x7675bfcf,mptr,0xf0154dc0
            name    "RES N,A"

.res_n_hl   flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xcb,0x86,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x38,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x00ff,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xeaf0e45d,all,0xe0112a76,docflags,0xeaf0e45d,doc,0xe0112a76,ccf,0xa20c0caf,mptr,0x5d434474
            name    "RES N,(HL)"

.res_n_r    flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xcb,0x80,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x3f,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0xffff,de,0xffff,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x2bb9d994,all,0x4a207df2,docflags,0x2bb9d994,doc,0x4a207df2,ccf,0x86080fa1,mptr,0x6f46591e
            name    "RES N,[R,(HL)]"

.res_n_xyd  flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xdd,0xcb,0x00,0x86,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,mem   ,iy,mem   ,sp,0xc000
            vec     0x20,0x00,0x00,0x38,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x01,0x00,mem,0x00ff,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0001,iy,0x0001,sp,0x0000
            crcs    allflags,0x2387ec0d,all,0x563d39de,docflags,0x2387ec0d,doc,0x563d39de,ccf,0xc90fadad,mptr,0xf6d0118d
            name    "RES N,(XY)"

.res_n_xyd_ flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xdd,0xcb,0x00,0x80,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,mem   ,iy,mem   ,sp,0xc000
            vec     0x20,0x00,0x00,0x3f,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x01,0x00,mem,0x00ff,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0001,iy,0x0001,sp,0x0000
            crcs    allflags,0xdf6769a7,all,0x54e6da74,docflags,0xdf6769a7,doc,0x54e6da74,ccf,0x43588b31,mptr,0x4ba4554c
            name    "RES N,(XY),R"
            
            ; Block instructions.

.ldi        flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xed,0xa0,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0x0001,de,mem   ,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0009,a,0x09,f,0x00,bc,0x0000,de,0x0001,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x00f6,a,0xf6,f,0xff,bc,0xffff,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x74905a21,all,0x171f174f,docflags,0x25ba7a54,doc,0x2ec1e096,ccf,0x082b1261,mptr,0x9c3ee85a
            name    "LDI"

.ldd        flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xed,0xa8,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0x0001,de,mem   ,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0009,a,0x09,f,0x00,bc,0x0000,de,0x0001,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x00f6,a,0xf6,f,0xff,bc,0xffff,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x74905a21,all,0xd752d9bc,docflags,0x25ba7a54,doc,0xee8c2e65,ccf,0x082b1261,mptr,0x9c3ee85a
            name    "LDD"

.ldir       flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xed,0xb0,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0x0001,de,mem   ,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0009,a,0x09,f,0x00,bc,0x0000,de,0x0001,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x00f6,a,0xf6,f,0xff,bc,0x0002,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x62a5e441,all,0xced3ea2d,docflags,0xb06f0da8,doc,0xec3d8ab1,ccf,0xe25b3a0b,mptr,0xec8a174b
            name    "LDIR"

.lddr       flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xed,0xb8,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0x0001,de,mem+1 ,hl,mem+1 ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0900,a,0x09,f,0x00,bc,0x0000,de,0x0001,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0xf600,a,0xf6,f,0xff,bc,0x0002,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x4650d4e7,all,0x495a8b20,docflags,0xb06f0da8,doc,0x63308b9d,ccf,0xe25b3a0b,mptr,0xec8a174b
            name    "LDDR"

.ldir_nop   flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xed,0xb0,stop,0x00,mem,0x0000,a,0xaa,f,0xff,bc,0x0000,de,self+1,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0009,a,0x09,f,0x00,bc,0x0001,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xf6,f,0xff,bc,0xfffe,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x97c3bacf,all,0xcc93b5ec,docflags,0xa4de6faa,doc,0xef3c3c61,ccf,0x75886449,mptr,0x88679670
            name    "LDIR->NOP'"

.lddr_nop   flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xed,0xb8,stop,0x00,mem,0x0000,a,0xaa,f,0xff,bc,0x0000,de,self+1,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0009,a,0x09,f,0x00,bc,0x0001,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xf6,f,0xff,bc,0xfffe,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x97c3bacf,all,0xcd491c09,docflags,0xa4de6faa,doc,0x5210121f,ccf,0x75886449,mptr,0x88679670
            name    "LDDR->NOP'"

.cpi        flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xed,0xa1,stop,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0001,de,0xddee,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0089,a,0x89,f,0x00,bc,0x0000,de,0x0000,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0076,a,0x76,f,0xff,bc,0xffff,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xb051c618,all,0xbe38bd05,docflags,0x563bc514,doc,0x1cb7d5cb,ccf,0x435c423d,mptr,0x82fe1009
            name    "CPI"

.cpd        flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xed,0xa9,stop,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0001,de,0xddee,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0089,a,0x89,f,0x00,bc,0x0000,de,0x0000,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0076,a,0x76,f,0xff,bc,0xffff,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xb051c618,all,0xc919bd72,docflags,0x563bc514,doc,0x6b96d5bc,ccf,0x435c423d,mptr,0x82fe1009
            name    "CPD"

.cpir       flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xed,0xb1,stop,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0001,de,0xddee,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0089,a,0x89,f,0x00,bc,0x0000,de,0x0000,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0076,a,0x76,f,0xff,bc,0x0002,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x7fe4a6e0,all,0x2e4300cb,docflags,0xe905a9e2,doc,0x54e35cb0,ccf,0xc93a1349,mptr,0xc83e7419
            name    "CPIR"

.cpdr       flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xed,0xb9,stop,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0001,de,0xddee,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x8900,a,0x89,f,0x00,bc,0x0000,de,0x0000,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x7600,a,0x76,f,0xff,bc,0x0002,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x76cc7038,all,0x9ddab56a,docflags,0x5dfed8d5,doc,0x38a78535,ccf,0xaea4d455,mptr,0xb9d65ad9
            name    "CPDR"
            
            ; Input/Output.

.in_a_n     flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xdb,0xfe,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x919e2255,all,0x15f7d9b8,docflags,0x919e2255,doc,0x15f7d9b8,ccf,0xc3f6460b,mptr,0x253c1992
            name    "IN A,(N)"
            db      incheck

.in_r_c    flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xed,0x40,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbfe,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x38,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x61f21a52,all,0xea2912bf,docflags,0xb6433321,doc,0x9c9c07ec,ccf,0x4801a633,mptr,0x587e9d23
            name    "IN R,(C)"
            db      incheck

.in_c       flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xed,0x70,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbfe,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x8f4b242f,all,0x68392c0e,docflags,0x41dd7fcb,doc,0xb285546f,ccf,0x1efcf040,mptr,0x253c1992
            name    "IN (C)"
            db      incheck

.ini        flags   s,0,z,1,f5,0,hc,0,f3,0,pv,0,n,0,c,0
            vec     0xed,0xa2,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0x00fe,de,0xddee,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0xff00,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x45c2bf9a,all,0x03da7534,docflags,0xdf14e043,doc,0x07d1b0d1,ccf,0x3c480ae3,mptr,0x630733cb
            name    "INI"
            db      incheck

.ind        flags   s,0,z,1,f5,0,hc,0,f3,0,pv,0,n,0,c,0
            vec     0xed,0xaa,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0x00fe,de,0xddee,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0xff00,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xa349e955,all,0x4c306b87,docflags,0xdf14e043,doc,0x3dc685fa,ccf,0xc90849ab,mptr,0x630733cb
            name    "IND"
            db      incheck

.inir       flags   s,0,z,1,f5,0,hc,0,f3,0,pv,0,n,0,c,0
            vec     0xed,0xb2,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0x01fe,de,0xddee,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0200,de,0x0000,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x95f331a2,all,0xb1c580a1,docflags,0x550e6d82,doc,0xf9e081a3,ccf,0x34683092,mptr,0x371c7dba
            name    "INIR"
            db      incheck

.indr       flags   s,0,z,1,f5,0,hc,0,f3,0,pv,0,n,0,c,0
            vec     0xed,0xba,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0x01fe,de,0xddee,hl,mem+1 ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0200,de,0x0000,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x845343ff,all,0x88f004aa,docflags,0x550e6d82,doc,0x62e607cf,ccf,0xe6771326,mptr,0x371c7dba
            name    "INDR"
            db      incheck

.inir_nop   flags   s,0,z,1,f5,0,hc,0,f3,0,pv,0,n,0,c,0
            vec     0xed,0xb2,stop,0x00,mem,0x0000,a,0xaa,f,0xff,bc,0x00fe,de,0xddee,hl,self+1,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x38,bc,0x0100,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xc7,bc,0xfe00,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x9d0cadce,all,0x454e3531,docflags,0x5cf12460,doc,0x3bbe489c,ccf,0xeee49e3b,mptr,0x0a537b63
            name    "INIR->NOP'"
            db      incheck

.indr_nop   flags   s,0,z,1,f5,0,hc,0,f3,0,pv,0,n,0,c,0
            vec     0xed,0xba,stop,0x00,mem,0x0000,a,0xaa,f,0xff,bc,0x00fe,de,0xddee,hl,self+1,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x38,bc,0x0100,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xc7,bc,0xfe00,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x739789b5,all,0x06bc40c4,docflags,0x5cf12460,doc,0x59928974,ccf,0xd2da9b2f,mptr,0x0a537b63
            name    "INDR->NOP'"
            db      incheck

.out_n_a    flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xd3,0xfe,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xf99ab3eb,all,0xfaafa4d0,docflags,0xf99ab3eb,doc,0xfaafa4d0,ccf,0x04270b9e,mptr,0x6d2bbd2a
            name    "OUT (N),A"

.out_c_r    flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xed,0x41,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0x00fe,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x38,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0xff,bc,0xff00,de,0xffff,hl,0xffff,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x2c0d4f69,all,0x57e2afd4,docflags,0x2c0d4f69,doc,0x57e2afd4,ccf,0x36547c3c,mptr,0xbf071c7d
            name    "OUT (C),R"
            
.out_c_0    flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xed,0x71,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0x00fe,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0xff,bc,0xff00,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xa6eacb74,all,0x5472fbd0,docflags,0xa6eacb74,doc,0x5472fbd0,ccf,0x226855e0,mptr,0xb7b56c76
            name    "OUT (C),0"

.outi       flags   s,0,z,1,f5,0,hc,0,f3,0,pv,0,n,0,c,0
            vec     0xed,0xa3,stop,0x00,mem,0x0000,a,0xaa,f,0xff,bc,0x00fe,de,0xddee,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0087,a,0x00,f,0x00,bc,0x8700,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0078,a,0x00,f,0xff,bc,0x7800,de,0x0000,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xf0c58202,all,0x6b09c8e2,docflags,0x27b692d1,doc,0x58c80d63,ccf,0xba903ab0,mptr,0xa8b663f9
            name    "OUTI"

.outd       flags   s,0,z,1,f5,0,hc,0,f3,0,pv,0,n,0,c,0
            vec     0xed,0xab,stop,0x00,mem,0x0000,a,0xaa,f,0xff,bc,0x00fe,de,0xddee,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0087,a,0x00,f,0x00,bc,0x8700,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0078,a,0x00,f,0xff,bc,0x7800,de,0x0000,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xfa1ad03e,all,0xc186ed7f,docflags,0x27b692d1,doc,0x5425a97b,ccf,0x03275bee,mptr,0xa8b663f9
            name    "OUTD"

.otir       flags   s,0,z,1,f5,0,hc,0,f3,0,pv,0,n,0,c,0
            vec     0xed,0xb3,stop,0x00,mem,0x0000,a,0xaa,f,0xff,bc,0x01fe,de,0xddee,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0087,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0078,a,0x00,f,0xff,bc,0x0200,de,0x0000,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x1a975ed3,all,0x366e1554,docflags,0x369c862e,doc,0xa24c0ff2,ccf,0x275e3430,mptr,0x9ff6297f
            name    "OTIR"

.otdr       flags   s,0,z,1,f5,0,hc,0,f3,0,pv,0,n,0,c,0
            vec     0xed,0xbb,stop,0x00,mem,0x0000,a,0xaa,f,0xff,bc,0x01fe,de,0xddee,hl,mem+1 ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x8700,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x7800,a,0x00,f,0xff,bc,0x0200,de,0x0000,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xb611c16f,all,0x1781b976,docflags,0x369c862e,doc,0x23b560db,ccf,0xde272f70,mptr,0xd7cf070f
            name    "OTDR"
            
            ; Jumps.

.jp_nn      flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xc3,jmpl,jmph,stop,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x919e2255,all,0x719d5e47,docflags,0x919e2255,doc,0x719d5e47,ccf,0xc3f6460b,mptr,0xebaa4276
            name    "JP NN"

.jp_cc_nn   flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xc2,jmpl,jmph,stop,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x38,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x8b69e182,all,0x0f8b6dcb,docflags,0x8b69e182,doc,0x0f8b6dcb,ccf,0x05e705e5,mptr,0x4f18bfbb
            name    "JP CC,NN"

.jp_hl      flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xe9,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,jmp   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x3692d4d4,all,0xc45f00be,docflags,0x3692d4d4,doc,0xc45f00be,ccf,0xba13c043,mptr,0xd33d5eb9
            name    "JP (HL)"

.jp_xy      flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xdd,0xe9,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,jmp   ,iy,jmp   ,sp,0xc000
            vec     0x20,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0001,iy,0x0001,sp,0x0000
            crcs    allflags,0xa33672df,all,0x799089df,docflags,0xa33672df,doc,0x799089df,ccf,0x865af2b2,mptr,0xc4b20f8c
            name    "JP (XY)"

.jr_n       flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0x18,0x00,0x03,stop,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x01,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xafe685dd,all,0x47c8f363,docflags,0xafe685dd,doc,0x47c8f363,ccf,0x699bbcea,mptr,0xe0cb1a62
            name    "JR N"

.jr_cc_n    flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0x20,0x00,0x03,stop,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x18,0x01,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x8b69e182,all,0xc7ef0fbd,docflags,0x8b69e182,doc,0xc7ef0fbd,ccf,0x05e705e5,mptr,0xd8878382
            name    "JR CC,N"

.djnz_n     flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0x10,0x00,0x03,stop,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x01,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0xff00,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x4031e70c,all,0x6c92b0b3,docflags,0x4031e70c,doc,0x6c92b0b3,ccf,0x44be1574,mptr,0x5ed4d6bd
            name    "DJNZ N"
            
            ; Calls.
            
.call_nn    flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xcd,jmpl,jmph,stop,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,mem ; not memsp!
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x919e2255,all,0x95eb1599,docflags,0x919e2255,doc,0x95eb1599,ccf,0xc3f6460b,mptr,0xebaa4276
            name    "CALL NN"

.call_cc_nn flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xc4,jmpl,jmph,stop,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,mem ; not memsp!
            vec     0x38,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x8b69e182,all,0x87b32d29,docflags,0x8b69e182,doc,0x87b32d29,ccf,0x05e705e5,mptr,0x4f18bfbb
            name    "CALL CC,NN"
            
            ; Returns.

.ret        flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xc9,stop,0x00,0x00,mem,jmp   ,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,mem
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x919e2255,all,0xb24f5c05,docflags,0x919e2255,doc,0xb24f5c05,ccf,0xc3f6460b,mptr,0xebaa4276
            name    "RET"

.ret_cc     flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xc0,stop,0x00,0x00,mem,jmp   ,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,mem
            vec     0x38,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x8b69e182,all,0x2b7f37ec,docflags,0x8b69e182,doc,0x2b7f37ec,ccf,0x05e705e5,mptr,0x4f18bfbb
            name    "RET CC"

.retn       flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xed,0x45,stop,0x00,mem,jmp   ,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,mem
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x919e2255,all,0xb24f5c05,docflags,0x919e2255,doc,0xb24f5c05,ccf,0xc3f6460b,mptr,0xebaa4276
            name    "RETN"

.reti       flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xed,0x4d,stop,0x00,mem,jmp   ,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,mem
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x919e2255,all,0xb24f5c05,docflags,0x919e2255,doc,0xb24f5c05,ccf,0xc3f6460b,mptr,0xebaa4276
            name    "RETI"

.reti_retn  flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xed,0x45,stop,0x00,mem,jmp   ,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,mem
            vec     0x00,0x38,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x8b69e182,all,0x1afc36b0,docflags,0x8b69e182,doc,0x1afc36b0,ccf,0x05e705e5,mptr,0x8fcfb450
            name    "RETI/RETN"

            ; Push/Pop.

.pushpop_rr flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xc5,0xc1,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,memsp
            vec     0x30,0x30,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x80,f,0xff,bc,0x8001,de,0x8001,hl,0x8001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xdac88897,all,0x249c42e7,docflags,0xdac88897,doc,0x249c42e7,ccf,0x15c4c121,mptr,0xee37c5cb
            name    "PUSH+POP RR"

.poppush_af flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xf1,0xf5,stop,0x00,mem,0x0000,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,mem
            vec     0x00,0x00,0x00,0x00,mem,0x00ff,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x8100,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x43219c3c,all,0x0deac469,docflags,0x43219c3c,doc,0x0deac469,ccf,0x4d06617f,mptr,0xf487ff91
            name    "POP+PUSH AF"

.pushpop_xy flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xdd,0xe5,0xdd,0xe1,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,memsp
            vec     0x20,0x00,0x20,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x8001,iy,0x8001,sp,0x0000
            crcs    allflags,0xb168fa73,all,0x68436a76,docflags,0xb168fa73,doc,0x68436a76,ccf,0xc0d02259,mptr,0xbb40d1fd
            name    "PUSH+POP XY"

            ; Register swapping.

.ex_de_hl   flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xeb,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x8001,hl,0x8001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x716b49bb,all,0x212155ff,docflags,0x716b49bb,doc,0x212155ff,ccf,0x9ff1906f,mptr,0xed1d720b
            name    "EX DE,HL"

.ex_af_af   flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0x08,0xf1,0xc5,0x08,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,mem
            vec     0x00,0x00,0x30,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x81ff,a,0x81,f,0xff,bc,0x8001,de,0x8001,hl,0x8001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x3b686884,all,0x7f6c68db,docflags,0x3b686884,doc,0x7f6c68db,ccf,0x4cfa32a0,mptr,0xa54c92b7
            name    "EX AF,AF'"

.exx        flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xd9,0xe1,0xc5,0xd9,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,mem
            vec     0x00,0x00,0x30,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x8001,a,0x81,f,0xff,bc,0x8001,de,0x8001,hl,0x8001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xea52817e,all,0xcf11ce0b,docflags,0xea52817e,doc,0xcf11ce0b,ccf,0xb0d477cd,mptr,0x7ffd5c45
            name    "EXX"

.ex_sp_hl   flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xe3,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,mem
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x8001,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x8001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x716b49bb,all,0x424b5572,docflags,0x716b49bb,doc,0x424b5572,ccf,0x9ff1906f,mptr,0x92523322
            name    "EX (SP),HL"

.ex_sp_xy   flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xdd,0xe3,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,mem
            vec     0x20,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x8001,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x8001,iy,0x8001,sp,0x0000
            crcs    allflags,0x0508a431,all,0x4f6123b9,docflags,0x0508a431,doc,0x4f6123b9,ccf,0x1eb64f30,mptr,0x91d12f85
            name    "EX (SP),XY"

            ; 8 bit transfer.

.ld_r_r     flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0x40,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x3f,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x8001,a,0x01,f,0xff,bc,0x8001,de,0x8001,hl,0x0001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x8cc99857,all,0x489568ef,docflags,0x8cc99857,doc,0x489568ef,ccf,0xbc21eb04,mptr,0x8e23d08e
            name    "LD [R,(HL)],[R,(HL)]"

.ld_x_x     flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xdd,0x40,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,mem-tail,iy,mem-tail,sp,0xc000
            vec     0x20,0x3f,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x8001,a,0x01,f,0xff,bc,0x8001,de,0x8001,hl,0x8001,ix,0x0001,iy,0x0001,sp,0x0000
            crcs    allflags,0x02d51675,all,0xf9a80f96,docflags,0x02d51675,doc,0xf9a80f96,ccf,0x889a70f6,mptr,0x8bd555d3
            name    "LD [X,(XY)],[X,(XY)]"

.ld_r_xyd   flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xdd,0x46,-128,stop,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,mem+128,iy,mem+128,sp,0xc000
            vec     0x20,0x38,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x01,0x00,mem,0x8001,a,0x01,f,0xff,bc,0x8001,de,0x8001,hl,0x8001,ix,0x0001,iy,0x0001,sp,0x0000
            crcs    allflags,0x322904d3,all,0xc4c0b4fe,docflags,0x322904d3,doc,0xc4c0b4fe,ccf,0xa29318c8,mptr,0xde3b0199
            name    "LD R,(XY)"

.ld_xyd_r   flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xdd,0x70,+126,stop,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,mem-126,iy,mem-126,sp,0xc000
            vec     0x20,0x07,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x01,0x00,mem,0x8001,a,0x01,f,0xff,bc,0x8001,de,0x8001,hl,0x8001,ix,0x0001,iy,0x0001,sp,0x0000
            crcs    allflags,0x322904d3,all,0xf64a5633,docflags,0x322904d3,doc,0xf64a5633,ccf,0xa81cad03,mptr,0xde3b0199
            name    "LD (XY),R"

.ld_r_n     flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0x06,0x00,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,mem   ,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x38,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0xff,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x835e406c,all,0x54c1de93,docflags,0x835e406c,doc,0x54c1de93,ccf,0x8bd6d3cd,mptr,0xe8e9b1ac
            name    "LD [R,(HL)],N"

.ld_x_n     flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xdd,0x26,0x00,stop,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x20,0x08,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0xff,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x004badd9,all,0x96b86077,docflags,0x004badd9,doc,0x96b86077,ccf,0x6fcf31e3,mptr,0x8f78380c
            name    "LD X,N"

.ld_xyd_n   flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xdd,0x36,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,mem   ,iy,mem   ,sp,0xc000
            vec     0x20,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x01,0xff,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0001,iy,0x0001,sp,0x0000
            crcs    allflags,0x8ad7acf3,all,0x5fb49529,docflags,0x8ad7acf3,doc,0x5fb49529,ccf,0x16f3e3af,mptr,0x76a22800
            name    "LD (XY),N"

.ld_a_rr    flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0x0a,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,mem   ,de,mem   ,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x10,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0001,de,0x0001,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x8b69e182,all,0x44659eca,docflags,0x8b69e182,doc,0x44659eca,ccf,0x5195291d,mptr,0xb4eabc1f
            name    "LD A,([BC,DE])"

.ld_rr_a    flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0x02,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,mem   ,de,mem   ,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x10,0x00,0x00,0x00,mem,0x0000,a,0x01,f,0x00,bc,0x0001,de,0x0001,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x2de08788,all,0x17fca30a,docflags,0x2de08788,doc,0x17fca30a,ccf,0xfb8c6d82,mptr,0x6de7210e
            name    "LD ([BC,DE]),A"

.ld_a_mem   flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0x3a,meml,memh,stop,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x01,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xafe685dd,all,0x6e96fa8f,docflags,0xafe685dd,doc,0x6e96fa8f,ccf,0x4f9c7261,mptr,0xe106f727
            name    "LD A,(NN)"

.ld_mem_a   flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0x32,meml,memh,stop,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x01,0x00,0x00,mem,0x0000,a,0x01,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x9cc1b7f3,all,0xf5408e38,docflags,0x9cc1b7f3,doc,0xf5408e38,ccf,0x2c174b9f,mptr,0xf6ae8c1d
            name    "LD (NN),A"
            
            ; 16 bit transfer.

.ld_rr_nn   flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0x01,0x00,0x00,stop,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x30,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0xff,0xff,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x868a302b,all,0x1a6b8abc,docflags,0x868a302b,doc,0x1a6b8abc,ccf,0x91a444f8,mptr,0xcfa6d5ee
            name    "LD RR,NN"

.ld_xy_nn   flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xdd,0x21,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x20,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0xff,0xff,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xf1a4ac7e,all,0xf728df10,docflags,0xf1a4ac7e,doc,0xf728df10,ccf,0x9671de69,mptr,0xa6965d85
            name    "LD XY,NN"

.ld_hl_mem  flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0x2a,meml,memh,stop,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x8001,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xac8a6b94,all,0x3103f88d,docflags,0xac8a6b94,doc,0x3103f88d,ccf,0x7049ee1e,mptr,0xfb9ef23e
            name    "LD HL,(NN)"

.ld_xy_mem  flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xdd,0x2a,meml,memh,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x20,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x8001,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xa33672df,all,0x68579189,docflags,0xa33672df,doc,0x68579189,ccf,0xaf311f28,mptr,0xcdb40688
            name    "LD XY,(NN)"

.ld_rr_mem  flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xed,0x4b,meml,memh,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x30,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x8001,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x1e1265f2,all,0x191f2bc3,docflags,0x1e1265f2,doc,0x191f2bc3,ccf,0x32ac7143,mptr,0x2960708f
            name    "LD RR,(NN)"

.ld_mem_hl  flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0x22,meml,memh,stop,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x8001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xac8a6b94,all,0x89eb910d,docflags,0xac8a6b94,doc,0x89eb910d,ccf,0x7049ee1e,mptr,0xfb9ef23e
            name    "LD (NN),HL"

.ld_mem_xy  flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xdd,0x22,meml,memh,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x20,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x8001,iy,0x8001,sp,0x0000
            crcs    allflags,0x313a5635,all,0xce4d5643,docflags,0x313a5635,doc,0xce4d5643,ccf,0x8ea4e97a,mptr,0x8891b6e5
            name    "LD (NN),XY"

.ld_mem_rr  flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xed,0x43,meml,memh,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x30,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x8001,de,0x8001,hl,0x8001,ix,0x0000,iy,0x0000,sp,0x8001
            crcs    allflags,0xcf735d07,all,0x231acf55,docflags,0xcf735d07,doc,0x231acf55,ccf,0x46aaf65e,mptr,0x86a92365
            name    "LD (NN),RR"

.ld_sp_hl   flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xf9,stop,0x00,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x8001,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xac8a6b94,all,0xc85266f2,docflags,0xac8a6b94,doc,0xc85266f2,ccf,0x7049ee1e,mptr,0xfb9ef23e
            name    "LD SP,HL"

.ld_sp_xy   flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xdd,0xf9,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x20,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x8001,iy,0x8001,sp,0x0000
            crcs    allflags,0x313a5635,all,0x982e8c00,docflags,0x313a5635,doc,0x982e8c00,ccf,0x8ea4e97a,mptr,0x8891b6e5
            name    "LD SP,XY"
            
            ; Special registers.

.ld_i_a     flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xed,0x47,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xf99ab3eb,all,0xfaafa4d0,docflags,0xf99ab3eb,doc,0xfaafa4d0,ccf,0x04270b9e,mptr,0xbd959484
            name    "LD I,A"

.ld_r_a     flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xed,0x4f,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xf99ab3eb,all,0xfaafa4d0,docflags,0xf99ab3eb,doc,0xfaafa4d0,ccf,0x04270b9e,mptr,0xbd959484
            name    "LD R,A"

.ld_a_i     flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xed,0x47,0xed,0x57,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0xdede7754,all,0x41c6359b,docflags,0x636fa3e4,doc,0x8344d7d6,ccf,0xc77d47f5,mptr,0xbd959484
            name    "LD A,I"

.ld_a_r     flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xed,0x4f,0xed,0x5f,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0xff,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x7a32e3f5,all,0xe3b3d437,docflags,0x8fbe6000,doc,0x095c9ee8,ccf,0x6391d354,mptr,0xbd959484
            name    "LD A,R"
            
            ; Interrupts.

.ei_di      flags   s,1,z,1,f5,0,hc,1,f3,0,pv,1,n,1,c,1
            vec     0xfb,0xf3,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x919e2255,all,0x3108b1a3,docflags,0x57357490,doc,0xd1718bee,ccf,0xc3f6460b,mptr,0x61fe077d
            name    "EI+DI"

.im_n       flags   s,1,z,1,f5,1,hc,1,f3,1,pv,1,n,1,c,1
            vec     0xed,0x46,stop,0x00,mem,0x1234,a,0xaa,f,0xff,bc,0xbbcc,de,0xddee,hl,0x4411,ix,0xdd88,iy,0xfd77,sp,0xc000
            vec     0x00,0x38,0x00,0x00,mem,0x0000,a,0x00,f,0x00,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            vec     0x00,0x00,0x00,0x00,mem,0x0000,a,0x00,f,0xff,bc,0x0000,de,0x0000,hl,0x0000,ix,0x0000,iy,0x0000,sp,0x0000
            crcs    allflags,0x8b69e182,all,0x44056d8c,docflags,0x8b69e182,doc,0x44056d8c,ccf,0x05e705e5,mptr,0xb4eabc1f
            name    "IM N"
            db      nocheck

; EOF ;
